#!/usr/bin/env bash
set -u
set -o pipefail

# Automate Miniconda installation
# setup_Miniforge.sh

env_name="fmosllm"

# Workaround for MacOS: 
export PATH=$PATH:/sbin:                     # md5 not found
export HOME="/Library/FileMakerLLM/"                # set home directory

# Resolve DEBUG parameter
DEBUG=0
if [ "$1" = "-debug" ]; then
  DEBUG=1
  export HOME=$PWD/../../../../../SCM/Tools/
  shift
fi

# Workaround for Ubuntu
if [ "$(uname -s)" = "Linux" ]; then
  export HOME="/opt/FileMaker/"
fi

miniforge_dir="$HOME/Open_Source_LLM/server/miniforge3"
env_dir="$miniforge_dir/envs/$env_name"

echo "*** Configuration:"
echo "  Miniforge directory:    $miniforge_dir"
echo "  Environment directory:  $env_dir"
echo ""

echo "PREPARING" > "$HOME/Open_Source_LLM/server/.status"

if [ ! -d "$miniforge_dir" ]; then
  # install miniconda
  echo "*** Installing Miniconda"
  mkdir -p "$miniforge_dir"
  mv "$miniforge_dir/../miniforge.sh" "$miniforge_dir/miniforge.sh"
  chmod +x "$miniforge_dir/miniforge.sh"
  "$miniforge_dir/miniforge.sh" -b -u -p "$miniforge_dir"
  echo "*** Miniconda Installation Complete"
else
  echo "*** Miniforge is Already Installed"
fi

if [ ! -d "$env_dir" ]; then
  if [ -f "$HOME/Open_Source_LLM/environment.yml" ]; then
      echo "$miniforge_dir/bin/conda env create -f $miniforge_dir/../../environment.yml --prefix=$miniforge_dir/envs/fmosllm"
      $miniforge_dir/bin/conda env create -f $miniforge_dir/../../environment.yml --prefix=$miniforge_dir/envs/fmosllm
  else
      echo "ERROR: environment.yml does not exist"
  fi

  # Workaround for: module 'jwt.exceptions' has no attribute 'DecodeError'.
  "$miniforge_dir/bin/conda" run -n $env_name bash -c "pip install jwt --no-input"
  "$miniforge_dir/bin/conda" run -n $env_name bash -c "pip uninstall PyJWT --yes"
  "$miniforge_dir/bin/conda" run -n $env_name bash -c "pip install PyJWT --no-input"

  if [[ "$(uname -s)" == "Darwin" && "$(uname -m)" == "arm64" ]]; then
    # This is a macOS ARM device
    echo "*** Installing mlx-lm for ARM"
    "$miniforge_dir/bin/conda" run -n $env_name bash -c "pip install mlx==0.24.1"
    "$miniforge_dir/bin/conda" run -n $env_name bash -c "pip install mlx-lm==0.22.2"
  fi
  
  # Clean up
  rm "$HOME/Open_Source_LLM/server/.status"
  echo "*** Setup Complete"
else
  echo "*** Environment $env_name already set up."
fi
